import numpy as np
import matplotlib.pyplot as p

fig = p.figure()
ax1 = fig.add_subplot(111)
t = np.arange(0.01,10.0,0.01)
s1 = np.exp(t)
ax1.plot(t,s1,'b-')
ax1.set_xlabel('time(s)')
ax1.set_ylabel('exp',color='b')
for t1 in ax1.get_yticklabels():
    t1.set_color('b')
ax2 = ax1.twinx()
s2 = np.sin(2*np.pi*t)
ax2.plot(t,s2,'r.')
ax2.set_ylabel('sin',color='r')
for t1 in ax2.get_yticklabels():
    t1.set_color('r')
ax3 = ax1.twinx()
s3 = np.cos(2*np.pi*t)
ax3.plot(t,s3,'gx')
ax3.set_ylabel('cos',color='g')
for t1 in ax3.get_yticklabels():
    t1.set_color('g')
p.show()
